package w83b.w83bBeans;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bDAO.w83bConstantesBD.W83bDelegacionesBD;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;

/**
 * 
 * 
 * @author jroncal
 * 
 */
public class W83bUsuarioXLNetsBean extends W83bBaseBean implements W83bBaseBeanBD{
	private static final long	serialVersionUID	= 1L;

	private String idUsuario = null;
	private String dniUsuario = null;
	private String nombreUsuario = null;
	private String nombrePersona = null;
	private String puestouid = null;
	private String telefonoPersona = null;
	private String mailPersona = null;
	
	private String codTerritorioDelegacion = null;
	private String calleDelegacion = null;
	private String numeroDelegacion = null;
	private String pisoDelegacion = null;
	private String letraDelegacion = null;
	private String codigoPostalDelegacion = null;
	private String localidadDelegacion = null;
	private String localidadTxtCastDelegacion = null;
	private String localidadTxtEuskDelegacion = null;
	private String telefono1Delegacion = null;
	private String telefono2Delegacion = null;
	private String faxDelegacion = null;
	private String regManual = null;
	private String modelo = null;
	private String modeloSal = null;
	private String localidadTxtCastDelegacionMin = null;
	private String localidadTxtEuskDelegacionMin = null;
	
	private String sessionTokenXLNets = "";
	private Document sessionTokenXLNetsDoc;
	private String loginXLNets = null;
	private List perfilXLNets = new ArrayList();

	//datos para el registro en el libro
	private String fechaRegistro = null;
	private String numRegistro = null;
	private String empresa = null;
	private String poblacion = null;
	private String observaciones = null;
	private String tipo = null;
	
	
	
	
	public String getTelefonoPersona() {
		return telefonoPersona;
	}
	public void setTelefonoPersona(String telefonoPersona) {
		this.telefonoPersona = telefonoPersona;
	}
	
	public String getMailPersona() {
		return mailPersona;
	}
	public void setMailPersona(String mailPersona) {
		this.mailPersona = mailPersona;
	}
	public String getLocalidadTxtCastDelegacionMin() {
		return localidadTxtCastDelegacionMin;
	}
	public void setLocalidadTxtCastDelegacionMin(
			String localidadTxtCastDelegacionMin) {
		this.localidadTxtCastDelegacionMin = localidadTxtCastDelegacionMin;
	}
	public String getLocalidadTxtEuskDelegacionMin() {
		return localidadTxtEuskDelegacionMin;
	}
	public void setLocalidadTxtEuskDelegacionMin(
			String localidadTxtEuskDelegacionMin) {
		this.localidadTxtEuskDelegacionMin = localidadTxtEuskDelegacionMin;
	}
	public String getIdUsuario() {
		return idUsuario;
	}
	public void setIdUsuario(String idUsuario) {
		this.idUsuario = idUsuario;
	}
	public String getDniUsuario() {
		return dniUsuario;
	}
	public void setDniUsuario(String dniUsuario) {
		this.dniUsuario = dniUsuario;
	}
	public String getNombreUsuario() {
		return nombreUsuario;
	}
	public void setNombreUsuario(String nombreUsuario) {
		this.nombreUsuario = nombreUsuario;
	}
	public List getPerfilXLNets() {
		return perfilXLNets;
	}
	public void setPerfilXLNets(List perfilXLNets) {
		this.perfilXLNets = perfilXLNets;
	}		
	public String getLoginXLNets() {
		return loginXLNets;
	}
	public void setLoginXLNets(String loginXLNets) {
		this.loginXLNets = loginXLNets;
	}
	public String getCodTerritorioDelegacion() {
		return codTerritorioDelegacion;
	}
	public void setCodTerritorioDelegacion(String codTerritorioDelegacion) {
		this.codTerritorioDelegacion = codTerritorioDelegacion;
	}
	public String getCalleDelegacion() {
		return calleDelegacion;
	}
	public void setCalleDelegacion(String calleDelegacion) {
		this.calleDelegacion = calleDelegacion;
	}
	public String getNumeroDelegacion() {
		return numeroDelegacion;
	}
	public void setNumeroDelegacion(String numeroDelegacion) {
		this.numeroDelegacion = numeroDelegacion;
	}
	public String getPisoDelegacion() {
		return pisoDelegacion;
	}
	public void setPisoDelegacion(String pisoDelegacion) {
		this.pisoDelegacion = pisoDelegacion;
	}
	public String getLetraDelegacion() {
		return letraDelegacion;
	}
	public void setLetraDelegacion(String letraDelegacion) {
		this.letraDelegacion = letraDelegacion;
	}
	public String getCodigoPostalDelegacion() {
		return codigoPostalDelegacion;
	}
	public void setCodigoPostalDelegacion(String codigoPostalDelegacion) {
		this.codigoPostalDelegacion = codigoPostalDelegacion;
	}
	public String getLocalidadDelegacion() {
		return localidadDelegacion;
	}
	public void setLocalidadDelegacion(String localidadDelegacion) {
		this.localidadDelegacion = localidadDelegacion;
	}
	public String getTelefono1Delegacion() {
		return telefono1Delegacion;
	}
	public void setTelefono1Delegacion(String telefono1Delegacion) {
		this.telefono1Delegacion = telefono1Delegacion;
	}
	public String getTelefono2Delegacion() {
		return telefono2Delegacion;
	}
	public void setTelefono2Delegacion(String telefono2Delegacion) {
		this.telefono2Delegacion = telefono2Delegacion;
	}
	public String getFaxDelegacion() {
		return faxDelegacion;
	}
	public void setFaxDelegacion(String faxDelegacion) {
		this.faxDelegacion = faxDelegacion;
	}	
	public String getSessionTokenXLNets() {
		return sessionTokenXLNets;
	}
	public void setSessionTokenXLNets(String sessionTokenXLNets) {
		this.sessionTokenXLNets = sessionTokenXLNets;
	}
	
	public Document getSessionTokenXLNetsDoc() {
		return sessionTokenXLNetsDoc;
	}
	public void setSessionTokenXLNetsDoc(Document sessionTokenXLNetsDoc) {
		this.sessionTokenXLNetsDoc = sessionTokenXLNetsDoc;
	}
	public String getPermisoXlnet(){
		return W83bUtilidadesN38API.elegirServiciosCentralosODelegacion(this.getPerfilXLNets());
	}
	
	public String getNombrePersona() {
		return nombrePersona;
	}
	public void setNombrePersona(String nombrePersona) {
		this.nombrePersona = nombrePersona;
	}
	
	
	public String getRegManual() {
		return regManual;
	}
	public void setRegManual(String regManual) {
		this.regManual = regManual;
	}
	
	public String getModelo() {
		return modelo;
	}
	public void setModelo(String modelo) {
		this.modelo = modelo;
	}
	
	public String getModeloSal() {
		return modeloSal;
	}
	public void setModeloSal(String modeloSal) {
		this.modeloSal = modeloSal;
	}
	public String getCalleListadosFormateada(){
		StringBuffer calle = new StringBuffer();
		
		calle.append(this.calleDelegacion);
		
		if(StringUtils.isNotEmpty(this.numeroDelegacion)){
			calle.append(" n ").append(this.numeroDelegacion);
		}
		
		if(StringUtils.isNotEmpty(this.pisoDelegacion)){
			calle.append(this.pisoDelegacion).append("");
		}
		
		if(StringUtils.isNotEmpty(this.telefono1Delegacion)){
			calle.append(" - Tel ").append(this.telefono1Delegacion);
		}
		
		if(StringUtils.isNotEmpty(this.faxDelegacion)){
			calle.append(" - Fax ").append(this.faxDelegacion);
		}
		
		if(StringUtils.isNotEmpty(this.codigoPostalDelegacion)||
			StringUtils.isNotEmpty(this.localidadDelegacion)){
			calle.append(" -");
		}
		
		if(StringUtils.isNotEmpty(this.codigoPostalDelegacion)){
			calle.append(" ").append(this.codigoPostalDelegacion);			
		}
		
		if(StringUtils.isNotEmpty(this.localidadTxtCastDelegacion)){
			calle.append(" ").append(this.localidadTxtCastDelegacion);			
		}
		
		return calle.toString();
	}
	
	public String getLocalidadTxtCastDelegacion() {
		return localidadTxtCastDelegacion;
	}
	public void setLocalidadTxtCastDelegacion(String localidadTxtCastDelegacion) {
		this.localidadTxtCastDelegacion = localidadTxtCastDelegacion;
	}
	public String getLocalidadTxtEuskDelegacion() {
		return localidadTxtEuskDelegacion;
	}
	
	
	
	public String getFechaRegistro() {
		return fechaRegistro;
	}
	public void setFechaRegistro(String fechaRegistro) {
		this.fechaRegistro = fechaRegistro;
	}
	public String getNumRegistro() {
		return numRegistro;
	}
	public void setNumRegistro(String numRegistro) {
		this.numRegistro = numRegistro;
	}
	public void setLocalidadTxtEuskDelegacion(String localidadTxtEuskDelegacion) {
		this.localidadTxtEuskDelegacion = localidadTxtEuskDelegacion;
	}
	
	public String getEmpresa() {
		return empresa;
	}
	public void setEmpresa(String empresa) {
		this.empresa = empresa;
	}
	
	public String getPoblacion() {
		return poblacion;
	}
	public void setPoblacion(String poblacion) {
		this.poblacion = poblacion;
	}
	public String getObservaciones() {
		return observaciones;
	}
	public void setObservaciones(String observaciones) {
		this.observaciones = observaciones;
	}
	
	public String getTipo() {
		return tipo;
	}
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}
	
	public String getPuestouid() {
		return puestouid;
	}
	public void setPuestouid(String puestouid) {
		this.puestouid = puestouid;
	}
	public Object rowToBean(Object o, Object otrosValores) throws Exception {
		// TODO Auto-generated method stub
		ResultSet rs = (ResultSet)o;//NOPMD
		
		W83bUsuarioXLNetsBean beanUsuarioBase = (W83bUsuarioXLNetsBean)((List)otrosValores).get(0);
		String modo = (String)((List)otrosValores).get(1);
		
		if("completo".equals(modo)){
			this.dniUsuario = beanUsuarioBase.getDniUsuario();
			this.idioma = beanUsuarioBase.getIdioma();
			this.loginXLNets = beanUsuarioBase.getLoginXLNets();
			this.nombrePersona = beanUsuarioBase.getNombrePersona();
			this.telefonoPersona = beanUsuarioBase.getTelefonoPersona();
			this.mailPersona = beanUsuarioBase.getMailPersona();
			this.perfilXLNets = beanUsuarioBase.getPerfilXLNets();
			this.sessionTokenXLNets = beanUsuarioBase.getSessionTokenXLNets();
			this.sessionTokenXLNetsDoc = beanUsuarioBase.getSessionTokenXLNetsDoc();
			this.idUsuario = beanUsuarioBase.getIdUsuario();
			this.puestouid = beanUsuarioBase.getPuestouid();
			
			this.codTerritorioDelegacion = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.C_TERRIT_051);
			this.calleDelegacion = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.CALLE_051);
			this.numeroDelegacion = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.NUM_051);
			this.pisoDelegacion = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.PISO_051);
			this.letraDelegacion = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.LETRA_051);
			this.codigoPostalDelegacion = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.CP_051);
			this.localidadDelegacion = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.LOCALIDAD_051);
			this.localidadTxtCastDelegacion = W83bDataBase.getStringFromRS(rs, "TXTCASLOCALIDAD");
			this.localidadTxtEuskDelegacion = W83bDataBase.getStringFromRS(rs, "TXTEUSLOCALIDAD");
			this.localidadTxtCastDelegacionMin = W83bDataBase.getStringFromRS(rs, "TXTCASLOCALIDADMIN");
			this.localidadTxtEuskDelegacionMin = W83bDataBase.getStringFromRS(rs, "TXTEUSLOCALIDADMIN");
			this.telefono1Delegacion = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.TELEFONO1_051);
			this.telefono2Delegacion = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.TELEFONO2_O51);
			this.faxDelegacion = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.FAX_051);
			this.regManual = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.REG_MANUAL_051);
			this.modelo = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.NUMMOD_051);
			this.modeloSal = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.NUMMODSAL_051);
		}else if("parcial".equals(modo)){
			this.dniUsuario = beanUsuarioBase.getDniUsuario();
			this.idioma = beanUsuarioBase.getIdioma();
			this.loginXLNets = beanUsuarioBase.getLoginXLNets();
			this.nombrePersona = beanUsuarioBase.getNombrePersona();
			this.telefonoPersona = beanUsuarioBase.getTelefonoPersona();
			this.mailPersona = beanUsuarioBase.getMailPersona();
			this.perfilXLNets = beanUsuarioBase.getPerfilXLNets();
			this.sessionTokenXLNets = beanUsuarioBase.getSessionTokenXLNets();
			this.sessionTokenXLNetsDoc = beanUsuarioBase.getSessionTokenXLNetsDoc();
			this.idUsuario = beanUsuarioBase.getIdUsuario();
			this.puestouid = beanUsuarioBase.getPuestouid();
			
			this.codTerritorioDelegacion = beanUsuarioBase.getCodTerritorioDelegacion();
			this.calleDelegacion = beanUsuarioBase.getCalleDelegacion();
			this.numeroDelegacion = beanUsuarioBase.getNumeroDelegacion();
			this.pisoDelegacion = beanUsuarioBase.getPisoDelegacion();
			this.letraDelegacion = beanUsuarioBase.getLetraDelegacion();
			this.codigoPostalDelegacion = beanUsuarioBase.getCodigoPostalDelegacion();
			this.localidadDelegacion = beanUsuarioBase.getLocalidadDelegacion();
			this.localidadTxtCastDelegacion = beanUsuarioBase.getLocalidadTxtCastDelegacion();
			this.localidadTxtEuskDelegacion = beanUsuarioBase.getLocalidadTxtEuskDelegacion();
			this.localidadTxtCastDelegacionMin = beanUsuarioBase.getLocalidadTxtCastDelegacionMin();
			this.localidadTxtEuskDelegacionMin = beanUsuarioBase.getLocalidadTxtEuskDelegacionMin();
			this.telefono1Delegacion = beanUsuarioBase.getTelefono1Delegacion();
			this.telefono2Delegacion = beanUsuarioBase.getTelefono2Delegacion();
			this.faxDelegacion = beanUsuarioBase.getFaxDelegacion();
			this.regManual = beanUsuarioBase.getRegManual();
			
			this.empresa = beanUsuarioBase.getEmpresa();
			this.poblacion = beanUsuarioBase.getPoblacion();
			this.observaciones = beanUsuarioBase.getObservaciones();
			this.tipo = beanUsuarioBase.getTipo();
			
			this.modelo = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.NUMMOD_051);
			this.modeloSal = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.NUMMODSAL_051);			
		}else if("parcialRegistroAutomat".equals(modo)){
			this.dniUsuario = beanUsuarioBase.getDniUsuario();
			this.idioma = beanUsuarioBase.getIdioma();
			this.loginXLNets = beanUsuarioBase.getLoginXLNets();
			this.nombrePersona = beanUsuarioBase.getNombrePersona();
			this.telefonoPersona = beanUsuarioBase.getTelefonoPersona();
			this.mailPersona = beanUsuarioBase.getMailPersona();
			this.perfilXLNets = beanUsuarioBase.getPerfilXLNets();
			this.sessionTokenXLNets = beanUsuarioBase.getSessionTokenXLNets();
			this.sessionTokenXLNetsDoc = beanUsuarioBase.getSessionTokenXLNetsDoc();
			this.idUsuario = beanUsuarioBase.getIdUsuario();
			this.puestouid = beanUsuarioBase.getPuestouid();
			
			this.codTerritorioDelegacion = beanUsuarioBase.getCodTerritorioDelegacion();
			this.calleDelegacion = beanUsuarioBase.getCalleDelegacion();
			this.numeroDelegacion = beanUsuarioBase.getNumeroDelegacion();
			this.pisoDelegacion = beanUsuarioBase.getPisoDelegacion();
			this.letraDelegacion = beanUsuarioBase.getLetraDelegacion();
			this.codigoPostalDelegacion = beanUsuarioBase.getCodigoPostalDelegacion();
			this.localidadDelegacion = beanUsuarioBase.getLocalidadDelegacion();
			this.localidadTxtCastDelegacion = beanUsuarioBase.getLocalidadTxtCastDelegacion();
			this.localidadTxtEuskDelegacion = beanUsuarioBase.getLocalidadTxtEuskDelegacion();
			this.localidadTxtCastDelegacionMin = beanUsuarioBase.getLocalidadTxtCastDelegacionMin();
			this.localidadTxtEuskDelegacionMin = beanUsuarioBase.getLocalidadTxtEuskDelegacionMin();
			this.telefono1Delegacion = beanUsuarioBase.getTelefono1Delegacion();
			this.telefono2Delegacion = beanUsuarioBase.getTelefono2Delegacion();
			this.faxDelegacion = beanUsuarioBase.getFaxDelegacion();
			this.regManual = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.REG_MANUAL_051);
			
			this.empresa = beanUsuarioBase.getEmpresa();
			this.poblacion = beanUsuarioBase.getPoblacion();
			this.observaciones = beanUsuarioBase.getObservaciones();
			this.tipo = beanUsuarioBase.getTipo();
			
			this.modelo = beanUsuarioBase.getModelo();
			this.modeloSal = beanUsuarioBase.getModeloSal();			
		}
		
		return beanUsuarioBase;
	}
}
